package com.team5.aLife.Client;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;

import com.google.gson.Gson;

public class AddUserActivity extends Activity {
	
	private final String TAG = "AddUserActivity:  ";
	
	private Button submit;
	
	private EditText userName, newPassword, confirmPassword;
	
	Spinner spinner;
	
	private final String delimiter = "[&]+";
	private Gson gson = new Gson();
	
	/** Called when the activity is first created. */
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.adduser);
        
        spinner = (Spinner) findViewById(R.id.spinner1);
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(
                this, R.array.access_level_array, android.R.layout.simple_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spinner.setAdapter(adapter);
        
        submit = (Button)findViewById(R.id.NewSubmitUser);
        userName = (EditText) findViewById(R.id.NewUserName);
        newPassword = (EditText) findViewById(R.id.NewPasswordUser);
        confirmPassword = (EditText) findViewById(R.id.NewReenterPassword);
                
        submit.setOnClickListener(submitListener);
        
    } // end onCreate
    
    private View.OnClickListener submitListener = new View.OnClickListener() {

        @Override
        public void onClick(View v) {
        	
        	if (!newPassword.getText().toString().equals(confirmPassword.getText().toString()))
        	{
        		AlertDialog.Builder builder = new AlertDialog.Builder(AddUserActivity.this);
            	builder.setMessage("The passwords do not match")
            	       .setCancelable(false)
            	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
            	           public void onClick(DialogInterface dialog, int id) {
            	        	   //RegisterDeviceActivity.this.finish();
            	           }
            	       });
            	AlertDialog alert = builder.create();
            	alert.show();
        	}
        	else
        	{
        		
        		User userToAdd = new User(0, userName.getText().toString(), newPassword.getText().toString(),
        								  spinner.getSelectedItem().toString(), 0,0,0);
	        	
        		AddUserRequest addUserRequest = new AddUserRequest(userToAdd);
        		
        		String replyString = socketDispatch.instance().sendReceive(addUserRequest);
        		
        		String[] tokens = replyString.split(delimiter);
        		
        		AddUserReply addUserReply = (AddUserReply) gson.fromJson(tokens[1], AddUserReply.class);
        		
        		if(addUserReply.didUserGetAdded())
        		{
        			AlertDialog.Builder builder = new AlertDialog.Builder(AddUserActivity.this);
                	builder.setMessage("Transaction Successful")
                	       .setCancelable(false)
                	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
                	           public void onClick(DialogInterface dialog, int id) {
                	        	   //RegisterDeviceActivity.this.finish();
                	           }
                	       });
                	AlertDialog alert = builder.create();
                	alert.show();
                	
        			finish();
        		}
        		else
        		{
        			AlertDialog.Builder builder = new AlertDialog.Builder(AddUserActivity.this);
                	builder.setMessage("Transaction Failed.  " + addUserReply.getErrorMessage())
                	       .setCancelable(false)
                	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
                	           public void onClick(DialogInterface dialog, int id) {
                	        	   //RegisterDeviceActivity.this.finish();
                	           }
                	       });
                	AlertDialog alert = builder.create();
                	alert.show();
        		}	        	
	        	
        	}
            
        }
    };
    
    

}
